REBOL [
	title: "Menu interactif"
	author: "Olivier Auverlot"
]

do %console-object.r

menu: copy [ "Ajouter" "Enregistrer" "Effacer" "Quitter" ]

affiche-menu: function [ pos ] [ x y ] [
	menu: head menu
	x: 5
	y: 2
	console/clear
	console/vline 3 1 console/size/height "|"
	until [
		console/at x y 
		either ((index? menu) = pos) [ 
			prin [ "[X] " (first menu) ] 
		] [ 
			prin [ "[ ] " (first menu) ]
		]
		menu: next menu
		y: y + 1
		(tail? menu)	
	]
	console/at 5 10 print "UP et DOWN pour dplacer le curseur"
	console/at 5 11 print "ENTER pour quitter"
	console/at 6 (1 + pos)
]

console/size/getsize
print "1"
sortie: false
choix: 1

until [
	affiche-menu choix
	touche: console/keyboard/getkey/wait
	if (first touche) = 1 [
		switch (second touche) [
			"UP" [ 
				if choix > 1 [ choix: choix - 1 ] 
			]
			"DOWN" [ 
				if choix < (length? head menu) [ choix: choix + 1 ] 
			]
			"ENTER" [ sortie: true ]
		]
	]
	(sortie = true)
]

